<?php

namespace Webkul\Invoice\Enums;

use Filament\Support\Contracts\HasLabel;

enum PartyIdentificationScheme: string implements HasLabel
{
    case SIRENE = '0002';
    case SWEDISH_ORG_NUMBER = '0007';
    case SIRET_CODE = '0009';
    case DUNS_NUMBER = '0060';
    case EAN_LOCATION_CODE = '0088';
    case DANISH_CHAMBER_OF_COMMERCE = '0096';
    case EDIFORUM_ITALIA = '0097';
    case NETHERLANDS_CHAMBER_OF_COMMERCE = '0106';
    case EC_DIRECTORATES = '0130';
    case SIA_OBJECT_IDENTIFIERS = '0135';
    case SECETI_OBJECT_IDENTIFIERS = '0142';
    case AUSTRALIAN_BUSINESS_NUMBER = '0151';
    case SWISS_BUSINESS_ID = '0183';
    case DIGSTORG = '0184';
    case JAPAN_CORPORATE_NUMBER = '0188';
    case DUTCH_ORIGINATOR_ID = '0190';
    case ESTONIA_BUSINESS_REGISTER = '0191';
    case NORWAY_BUSINESS_REGISTER = '0192';
    case UBL_BE_PARTY_ID = '0193';
    case SINGAPORE_UEN = '0195';
    case ICELAND_KENNITALA = '0196';
    case ERSTORG = '0198';
    case LEGAL_ENTITY_IDENTIFIER = '0199';
    case LITHUANIA_LEGAL_ENTITY = '0200';
    case ITALY_IPA_CODE = '0201';
    case ITALY_CERTIFIED_EMAIL = '0202';
    case LEITWEG_ID = '0204';
    case BELGIUM_ENTERPRISE_NUMBER = '0208';
    case GS1_IDENTIFICATION_KEYS = '0209';
    case ITALY_CODICE_FISCALE = '0210';
    case ITALY_PARTITA_IVA = '0211';
    case FINLAND_OVTCODE = '0216';
    case JAPAN_QUALIFIED_INVOICE_ISSUER = '0221';
    case MALAYSIA_EINVOICING_FRAMEWORK = '0230';
    case HUNGARY_VAT_NUMBER = '9910';
    case BUSINESS_REGISTERS_NETWORK = '9913';
    case AUSTRIA_VAT_NUMBER = '9914';
    case AUSTRIA_ADMINISTRATIVE_CODE = '9915';
    case SWIFT_CODE = '9918';
    case GERMANY_BUSINESS_REGISTER_NUMBER = '9919';
    case SPAIN_TAX_AGENCY = '9920';
    case ANDORRA_VAT_NUMBER = '9922';
    case ALBANIA_VAT_NUMBER = '9923';
    case BOSNIA_VAT_NUMBER = '9924';
    case BELGIUM_VAT_NUMBER = '9925';
    case BULGARIA_VAT_NUMBER = '9926';
    case SWITZERLAND_VAT_NUMBER = '9927';
    case CYPRUS_VAT_NUMBER = '9928';
    case CZECH_VAT_NUMBER = '9929';
    case GERMANY_VAT_NUMBER = '9930';
    case ESTONIA_VAT_NUMBER = '9931';
    case UK_VAT_NUMBER = '9932';
    case GREECE_VAT_NUMBER = '9933';
    case CROATIA_VAT_NUMBER = '9934';
    case IRELAND_VAT_NUMBER = '9935';
    case LIECHTENSTEIN_VAT_NUMBER = '9936';
    case LITHUANIA_VAT_NUMBER = '9937';
    case LUXEMBOURG_VAT_NUMBER = '9938';
    case LATVIA_VAT_NUMBER = '9939';
    case MONACO_VAT_NUMBER = '9940';
    case MONTENEGRO_VAT_NUMBER = '9941';
    case MACEDONIA_VAT_NUMBER = '9942';
    case MALTA_VAT_NUMBER = '9943';
    case NETHERLANDS_VAT_NUMBER = '9944';
    case POLAND_VAT_NUMBER = '9945';
    case PORTUGAL_VAT_NUMBER = '9946';
    case ROMANIA_VAT_NUMBER = '9947';
    case SERBIA_VAT_NUMBER = '9948';
    case SLOVENIA_VAT_NUMBER = '9949';
    case SLOVAKIA_VAT_NUMBER = '9950';
    case SAN_MARINO_VAT_NUMBER = '9951';
    case TURKEY_VAT_NUMBER = '9952';
    case VATICAN_VAT_NUMBER = '9953';
    case FRANCE_VAT_NUMBER = '9957';
    case US_EMPLOYER_ID_NUMBER = '9959';

    public function getLabel(): ?string
    {
        return match ($this) {
            self::SIRENE                           => __('invoices::enums/party-identification-scheme.sirene'),
            self::SWEDISH_ORG_NUMBER               => __('invoices::enums/party-identification-scheme.swedish-org-number'),
            self::SIRET_CODE                       => __('invoices::enums/party-identification-scheme.siret-code'),
            self::DUNS_NUMBER                      => __('invoices::enums/party-identification-scheme.duns-number'),
            self::EAN_LOCATION_CODE                => __('invoices::enums/party-identification-scheme.ean-location-code'),
            self::DANISH_CHAMBER_OF_COMMERCE       => __('invoices::enums/party-identification-scheme.danish-chamber-of-commerce'),
            self::EDIFORUM_ITALIA                  => __('invoices::enums/party-identification-scheme.ediforum-italia'),
            self::NETHERLANDS_CHAMBER_OF_COMMERCE  => __('invoices::enums/party-identification-scheme.netherlands-chamber-of-commerce'),
            self::EC_DIRECTORATES                  => __('invoices::enums/party-identification-scheme.ec-directorates'),
            self::SIA_OBJECT_IDENTIFIERS           => __('invoices::enums/party-identification-scheme.sia-object-identifiers'),
            self::SECETI_OBJECT_IDENTIFIERS        => __('invoices::enums/party-identification-scheme.seceti-object-identifiers'),
            self::AUSTRALIAN_BUSINESS_NUMBER       => __('invoices::enums/party-identification-scheme.australian-business-number'),
            self::SWISS_BUSINESS_ID                => __('invoices::enums/party-identification-scheme.swiss-business-id'),
            self::DIGSTORG                         => __('invoices::enums/party-identification-scheme.digstorg'),
            self::JAPAN_CORPORATE_NUMBER           => __('invoices::enums/party-identification-scheme.japan-corporate-number'),
            self::DUTCH_ORIGINATOR_ID              => __('invoices::enums/party-identification-scheme.dutch-originator-id'),
            self::ESTONIA_BUSINESS_REGISTER        => __('invoices::enums/party-identification-scheme.estonia-business-register'),
            self::NORWAY_BUSINESS_REGISTER         => __('invoices::enums/party-identification-scheme.norway-business-register'),
            self::UBL_BE_PARTY_ID                  => __('invoices::enums/party-identification-scheme.ubl-be-party-id'),
            self::SINGAPORE_UEN                    => __('invoices::enums/party-identification-scheme.singapore-uen'),
            self::ICELAND_KENNITALA                => __('invoices::enums/party-identification-scheme.iceland-kennitala'),
            self::ERSTORG                          => __('invoices::enums/party-identification-scheme.erstorg'),
            self::LEGAL_ENTITY_IDENTIFIER          => __('invoices::enums/party-identification-scheme.legal-entity-identifier'),
            self::LITHUANIA_LEGAL_ENTITY           => __('invoices::enums/party-identification-scheme.lithuania-legal-entity'),
            self::ITALY_IPA_CODE                   => __('invoices::enums/party-identification-scheme.italy-ipa-code'),
            self::ITALY_CERTIFIED_EMAIL            => __('invoices::enums/party-identification-scheme.italy-certified-email'),
            self::LEITWEG_ID                       => __('invoices::enums/party-identification-scheme.leitweg-id'),
            self::BELGIUM_ENTERPRISE_NUMBER        => __('invoices::enums/party-identification-scheme.belgium-enterprise-number'),
            self::GS1_IDENTIFICATION_KEYS          => __('invoices::enums/party-identification-scheme.gs1-identification-keys'),
            self::ITALY_CODICE_FISCALE             => __('invoices::enums/party-identification-scheme.italy-codice-fiscale'),
            self::ITALY_PARTITA_IVA                => __('invoices::enums/party-identification-scheme.italy-partita-iva'),
            self::FINLAND_OVTCODE                  => __('invoices::enums/party-identification-scheme.finland-ovtcode'),
            self::JAPAN_QUALIFIED_INVOICE_ISSUER   => __('invoices::enums/party-identification-scheme.japan-qualified-invoice-issuer'),
            self::MALAYSIA_EINVOICING_FRAMEWORK    => __('invoices::enums/party-identification-scheme.malaysia-einvoicing-framework'),
            self::HUNGARY_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.hungary-vat-number'),
            self::BUSINESS_REGISTERS_NETWORK       => __('invoices::enums/party-identification-scheme.business-registers-network'),
            self::AUSTRIA_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.austria-vat-number'),
            self::AUSTRIA_ADMINISTRATIVE_CODE      => __('invoices::enums/party-identification-scheme.austria-administrative-code'),
            self::SWIFT_CODE                       => __('invoices::enums/party-identification-scheme.swift-code'),
            self::GERMANY_BUSINESS_REGISTER_NUMBER => __('invoices::enums/party-identification-scheme.germany-business-register-number'),
            self::SPAIN_TAX_AGENCY                 => __('invoices::enums/party-identification-scheme.spain-tax-agency'),
            self::ANDORRA_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.andorra-vat-number'),
            self::ALBANIA_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.albania-vat-number'),
            self::BOSNIA_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.bosnia-vat-number'),
            self::BELGIUM_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.belgium-vat-number'),
            self::BULGARIA_VAT_NUMBER              => __('invoices::enums/party-identification-scheme.bulgaria-vat-number'),
            self::SWITZERLAND_VAT_NUMBER           => __('invoices::enums/party-identification-scheme.switzerland-vat-number'),
            self::CYPRUS_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.cyprus-vat-number'),
            self::CZECH_VAT_NUMBER                 => __('invoices::enums/party-identification-scheme.czech-vat-number'),
            self::GERMANY_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.germany-vat-number'),
            self::ESTONIA_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.estonia-vat-number'),
            self::UK_VAT_NUMBER                    => __('invoices::enums/party-identification-scheme.uk-vat-number'),
            self::GREECE_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.greece-vat-number'),
            self::CROATIA_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.croatia-vat-number'),
            self::IRELAND_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.ireland-vat-number'),
            self::LIECHTENSTEIN_VAT_NUMBER         => __('invoices::enums/party-identification-scheme.liechtenstein-vat-number'),
            self::LITHUANIA_VAT_NUMBER             => __('invoices::enums/party-identification-scheme.lithuania-vat-number'),
            self::LUXEMBOURG_VAT_NUMBER            => __('invoices::enums/party-identification-scheme.luxembourg-vat-number'),
            self::LATVIA_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.latvia-vat-number'),
            self::MONACO_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.monaco-vat-number'),
            self::MONTENEGRO_VAT_NUMBER            => __('invoices::enums/party-identification-scheme.montenegro-vat-number'),
            self::MACEDONIA_VAT_NUMBER             => __('invoices::enums/party-identification-scheme.macedonia-vat-number'),
            self::MALTA_VAT_NUMBER                 => __('invoices::enums/party-identification-scheme.malta-vat-number'),
            self::NETHERLANDS_VAT_NUMBER           => __('invoices::enums/party-identification-scheme.netherlands-vat-number'),
            self::POLAND_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.poland-vat-number'),
            self::PORTUGAL_VAT_NUMBER              => __('invoices::enums/party-identification-scheme.portugal-vat-number'),
            self::ROMANIA_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.romania-vat-number'),
            self::SERBIA_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.serbia-vat-number'),
            self::SLOVENIA_VAT_NUMBER              => __('invoices::enums/party-identification-scheme.slovenia-vat-number'),
            self::SLOVAKIA_VAT_NUMBER              => __('invoices::enums/party-identification-scheme.slovakia-vat-number'),
            self::SAN_MARINO_VAT_NUMBER            => __('invoices::enums/party-identification-scheme.san-marino-vat-number'),
            self::TURKEY_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.turkey-vat-number'),
            self::VATICAN_VAT_NUMBER               => __('invoices::enums/party-identification-scheme.vatican-vat-number'),
            self::FRANCE_VAT_NUMBER                => __('invoices::enums/party-identification-scheme.france-vat-number'),
            self::US_EMPLOYER_ID_NUMBER            => __('invoices::enums/party-identification-scheme.us-employer-id-number'),
        };
    }

    public static function options(): array
    {
        return [
            self::SIRENE->value                           => __('invoices::enums/party-identification-scheme.sirene'),
            self::SWEDISH_ORG_NUMBER->value               => __('invoices::enums/party-identification-scheme.swedish-org-number'),
            self::SIRET_CODE->value                       => __('invoices::enums/party-identification-scheme.siret-code'),
            self::DUNS_NUMBER->value                      => __('invoices::enums/party-identification-scheme.duns-number'),
            self::EAN_LOCATION_CODE->value                => __('invoices::enums/party-identification-scheme.ean-location-code'),
            self::DANISH_CHAMBER_OF_COMMERCE->value       => __('invoices::enums/party-identification-scheme.danish-chamber-of-commerce'),
            self::EDIFORUM_ITALIA->value                  => __('invoices::enums/party-identification-scheme.ediforum-italia'),
            self::NETHERLANDS_CHAMBER_OF_COMMERCE->value  => __('invoices::enums/party-identification-scheme.netherlands-chamber-of-commerce'),
            self::EC_DIRECTORATES->value                  => __('invoices::enums/party-identification-scheme.ec-directorates'),
            self::SIA_OBJECT_IDENTIFIERS->value           => __('invoices::enums/party-identification-scheme.sia-object-identifiers'),
            self::SECETI_OBJECT_IDENTIFIERS->value        => __('invoices::enums/party-identification-scheme.seceti-object-identifiers'),
            self::AUSTRALIAN_BUSINESS_NUMBER->value       => __('invoices::enums/party-identification-scheme.australian-business-number'),
            self::SWISS_BUSINESS_ID->value                => __('invoices::enums/party-identification-scheme.swiss-business-id'),
            self::DIGSTORG->value                         => __('invoices::enums/party-identification-scheme.digstorg'),
            self::JAPAN_CORPORATE_NUMBER->value           => __('invoices::enums/party-identification-scheme.japan-corporate-number'),
            self::DUTCH_ORIGINATOR_ID->value              => __('invoices::enums/party-identification-scheme.dutch-originator-id'),
            self::ESTONIA_BUSINESS_REGISTER->value        => __('invoices::enums/party-identification-scheme.estonia-business-register'),
            self::NORWAY_BUSINESS_REGISTER->value         => __('invoices::enums/party-identification-scheme.norway-business-register'),
            self::UBL_BE_PARTY_ID->value                  => __('invoices::enums/party-identification-scheme.ubl-be-party-id'),
            self::SINGAPORE_UEN->value                    => __('invoices::enums/party-identification-scheme.singapore-uen'),
            self::ICELAND_KENNITALA->value                => __('invoices::enums/party-identification-scheme.iceland-kennitala'),
            self::ERSTORG->value                          => __('invoices::enums/party-identification-scheme.erstorg'),
            self::LEGAL_ENTITY_IDENTIFIER->value          => __('invoices::enums/party-identification-scheme.legal-entity-identifier'),
            self::LITHUANIA_LEGAL_ENTITY->value           => __('invoices::enums/party-identification-scheme.lithuania-legal-entity'),
            self::ITALY_IPA_CODE->value                   => __('invoices::enums/party-identification-scheme.italy-ipa-code'),
            self::ITALY_CERTIFIED_EMAIL->value            => __('invoices::enums/party-identification-scheme.italy-certified-email'),
            self::LEITWEG_ID->value                       => __('invoices::enums/party-identification-scheme.leitweg-id'),
            self::BELGIUM_ENTERPRISE_NUMBER->value        => __('invoices::enums/party-identification-scheme.belgium-enterprise-number'),
            self::GS1_IDENTIFICATION_KEYS->value          => __('invoices::enums/party-identification-scheme.gs1-identification-keys'),
            self::ITALY_CODICE_FISCALE->value             => __('invoices::enums/party-identification-scheme.italy-codice-fiscale'),
            self::ITALY_PARTITA_IVA->value                => __('invoices::enums/party-identification-scheme.italy-partita-iva'),
            self::FINLAND_OVTCODE->value                  => __('invoices::enums/party-identification-scheme.finland-ovtcode'),
            self::JAPAN_QUALIFIED_INVOICE_ISSUER->value   => __('invoices::enums/party-identification-scheme.japan-qualified-invoice-issuer'),
            self::MALAYSIA_EINVOICING_FRAMEWORK->value    => __('invoices::enums/party-identification-scheme.malaysia-einvoicing-framework'),
            self::HUNGARY_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.hungary-vat-number'),
            self::BUSINESS_REGISTERS_NETWORK->value       => __('invoices::enums/party-identification-scheme.business-registers-network'),
            self::AUSTRIA_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.austria-vat-number'),
            self::AUSTRIA_ADMINISTRATIVE_CODE->value      => __('invoices::enums/party-identification-scheme.austria-administrative-code'),
            self::SWIFT_CODE->value                       => __('invoices::enums/party-identification-scheme.swift-code'),
            self::GERMANY_BUSINESS_REGISTER_NUMBER->value => __('invoices::enums/party-identification-scheme.germany-business-register-number'),
            self::SPAIN_TAX_AGENCY->value                 => __('invoices::enums/party-identification-scheme.spain-tax-agency'),
            self::ANDORRA_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.andorra-vat-number'),
            self::ALBANIA_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.albania-vat-number'),
            self::BOSNIA_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.bosnia-vat-number'),
            self::BELGIUM_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.belgium-vat-number'),
            self::BULGARIA_VAT_NUMBER->value              => __('invoices::enums/party-identification-scheme.bulgaria-vat-number'),
            self::SWITZERLAND_VAT_NUMBER->value           => __('invoices::enums/party-identification-scheme.switzerland-vat-number'),
            self::CYPRUS_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.cyprus-vat-number'),
            self::CZECH_VAT_NUMBER->value                 => __('invoices::enums/party-identification-scheme.czech-vat-number'),
            self::GERMANY_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.germany-vat-number'),
            self::ESTONIA_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.estonia-vat-number'),
            self::UK_VAT_NUMBER->value                    => __('invoices::enums/party-identification-scheme.uk-vat-number'),
            self::GREECE_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.greece-vat-number'),
            self::CROATIA_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.croatia-vat-number'),
            self::IRELAND_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.ireland-vat-number'),
            self::LIECHTENSTEIN_VAT_NUMBER->value         => __('invoices::enums/party-identification-scheme.liechtenstein-vat-number'),
            self::LITHUANIA_VAT_NUMBER->value             => __('invoices::enums/party-identification-scheme.lithuania-vat-number'),
            self::LUXEMBOURG_VAT_NUMBER->value            => __('invoices::enums/party-identification-scheme.luxembourg-vat-number'),
            self::LATVIA_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.latvia-vat-number'),
            self::MONACO_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.monaco-vat-number'),
            self::MONTENEGRO_VAT_NUMBER->value            => __('invoices::enums/party-identification-scheme.montenegro-vat-number'),
            self::MACEDONIA_VAT_NUMBER->value             => __('invoices::enums/party-identification-scheme.macedonia-vat-number'),
            self::MALTA_VAT_NUMBER->value                 => __('invoices::enums/party-identification-scheme.malta-vat-number'),
            self::NETHERLANDS_VAT_NUMBER->value           => __('invoices::enums/party-identification-scheme.netherlands-vat-number'),
            self::POLAND_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.poland-vat-number'),
            self::PORTUGAL_VAT_NUMBER->value              => __('invoices::enums/party-identification-scheme.portugal-vat-number'),
            self::ROMANIA_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.romania-vat-number'),
            self::SERBIA_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.serbia-vat-number'),
            self::SLOVENIA_VAT_NUMBER->value              => __('invoices::enums/party-identification-scheme.slovenia-vat-number'),
            self::SLOVAKIA_VAT_NUMBER->value              => __('invoices::enums/party-identification-scheme.slovakia-vat-number'),
            self::SAN_MARINO_VAT_NUMBER->value            => __('invoices::enums/party-identification-scheme.san-marino-vat-number'),
            self::TURKEY_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.turkey-vat-number'),
            self::VATICAN_VAT_NUMBER->value               => __('invoices::enums/party-identification-scheme.vatican-vat-number'),
            self::FRANCE_VAT_NUMBER->value                => __('invoices::enums/party-identification-scheme.france-vat-number'),
            self::US_EMPLOYER_ID_NUMBER->value            => __('invoices::enums/party-identification-scheme.us-employer-id-number'),
        ];
    }
}
